const express = require("express");
const router = express.Router();
const partnerController = require("../controllers/partnerController");
const {
  uploadPartnerImage,
} = require("../storage/middlewareStorage/uploadPartnerMedia");
const authController = require("../controllers/authController");
const checkApiKey = require("../utils/checkApiKey");

// --- Public Routes (API Key Protected) ---
router.route("/").get(checkApiKey, partnerController.getAllPartners);

router.route("/:id").get(checkApiKey, partnerController.getPartner);

// --- Protected Routes (Admin Only) ---
router.use(authController.protect);
router.use(authController.restrictTo("admin", "super-admin"));

router.route("/").post(uploadPartnerImage, partnerController.createPartner);

router
  .route("/:id")
  .patch(uploadPartnerImage, partnerController.updatePartner)
  .delete(partnerController.deletePartner);

module.exports = router;
